/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2005 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef MX__REGCACHE_H
#define MX__REGCACHE_H

#include "mx__thread.h"
#include "bsd/queue.h"

extern MX__MUTEX_T Mx_rcache_lock;

/* return 1 if we have the possibiliy of using a registration cache */
int mx__regcache_works(void);

/* callback used by the OS depending code to tell a portion of the address
   space changed */
MX_FUNC(void) mx__regcache_clean(void *ptr, size_t size);

struct mx__rdmawin {
  int rdma_id;
  int send;
  uintptr_t addr;
  uint32_t len;
  struct mx_endpoint *ep;
  TAILQ_ENTRY(mx__rdmawin) list;
};

#if MX_OS_UDRV
extern char *mx__init_brk;
#endif

#endif /* MX__REGCACHE_H */
